// ==UserScript==
// @name         5ch 行間空行が連続したら空行削除
// @namespace    https://example.com/
// @version      1.0.0
// @description  テキスト行間の空白行が3連続以上続く場合に2つまでに減らす
// @match        *://*.5ch.net/test/read.cgi/*
// @grant        none
// ==/UserScript==

(function () {
    'use strict';

    function isEmptyNode(node) {
        // <br>タグ、または空白だけのテキストノードを空白行とみなす
        if (node.nodeType === 1 && node.tagName === 'BR') return true;
        if (node.nodeType === 3 && /^\s*$/.test(node.textContent)) return true;
        return false;
    }

    function collapseEmptyLines(post) {
        if (post.dataset.emptyCollapsed) return;
        post.dataset.emptyCollapsed = 'true';

        const nodes = Array.from(post.childNodes);
        let emptyLineCount = 0;
        let emptyNodes = [];

        for (let i = 0; i <= nodes.length; i++) {
            const node = nodes[i];
            if (node && isEmptyNode(node)) {
                emptyLineCount++;
                emptyNodes.push(node);
            } else {
                if (emptyLineCount >= 3) {
                    // 3連続以上の空白行があったら3つ目以降削除し2つだけ残す
                    for (let j = 2; j < emptyNodes.length; j++) {
                        emptyNodes[j].remove();
                    }
                }
                emptyLineCount = 0;
                emptyNodes = [];
            }
        }
    }

    // 表示領域に入った投稿だけ処理
    const observer = new IntersectionObserver((entries, obs) => {
        for (const entry of entries) {
            if (entry.isIntersecting) {
                collapseEmptyLines(entry.target);
                obs.unobserve(entry.target);
            }
        }
    });

    // 初期監視開始
    document.querySelectorAll('.post-content').forEach(el => observer.observe(el));

    // 投稿動的追加対応
    const mo = new MutationObserver(mutations => {
        for (const m of mutations) {
            for (const node of m.addedNodes) {
                if (!(node instanceof HTMLElement)) continue;
                if (node.matches('.post-content')) {
                    observer.observe(node);
                } else {
                    node.querySelectorAll?.('.post-content').forEach(child => observer.observe(child));
                }
            }
        }
    });

    mo.observe(document.body, { childList: true, subtree: true });
})();
